odoo.define("ab_openstreetmap.openstreetmap_widget", function (require) {
  "use strict";
  var fieldRegistry = require("web.field_registry");
  var abstractField = require("web.AbstractField");

  var openstreetmap = abstractField.extend({
    template: "openstreetmap_template",
    start: function () {
      var self = this;
      this._super();
      self._initMap();
    },
    _initMap: function () {
      var self = this
      $(document).ready(function () {
        setTimeout(() => {
          var lat = self.recordData.lat;
          var lng = self.recordData.lng;
          
          if (!lat && !lng) {
            lat = -6.2349;
            lng = 106.9896;
          }
          
          var mymap = L.map('mapid').setView([lat, lng], 13);
          L.tileLayer("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png", {
            attribution:
            '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors',
          }).addTo(mymap);

          var edit = self.mode == "edit" ? true : false;
          var marker = L.marker([lat, lng], { draggable: edit }).addTo(mymap);
          
          marker.on("dragend", function (e) {
            var latlng = e.target._latlng;
            self.trigger_up("field_changed", {
              dataPointID: self.dataPointID,
              changes: {
                lat: latlng.lat,
                lng: latlng.lng,
              },
              viewType: self.viewType,
            });
          });
          
          if (edit) {
            var geocode = L.Control.geocoder({
              defaultMarkGeocode: false,
            }).addTo(mymap);
            
            geocode.on("markgeocode", function (e) {
              var lat = e.geocode.center.lat;
              var lng = e.geocode.center.lng;
              
              mymap.flyTo([lat, lng]);
              marker.setLatLng(new L.LatLng(lat, lng));
              self.trigger_up("field_changed", {
                dataPointID: self.dataPointID,
                changes: {
                  lat: lat,
                  lng: lng,
                },
                viewType: self.viewType,
              });
            });
          }

          var interval = setInterval(() => {
            if (mymap && mymap._size.x > 0){
              clearInterval(interval);
            } else if (!document.getElementById("mapid")) {
              clearInterval(interval);
            }
            window.dispatchEvent(new Event("resize"));
          }, 500);
        }, 100);

      });
    },
    isSet: function () {
      return true;
    },
  });
  
  fieldRegistry.add("openstreetmap", openstreetmap);
});
